<!DOCTYPE html>
<html id="html" lang="en">

<head>

    <meta charset="UTF-8">
    <title>Add Email photos</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">


    <!-- cities select box -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"></script>


    <!-- local css -->
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/normalize.css')}}">
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/preloader.css')}}">
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/add_product_style.css')}}">
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/copyright.css')}}">
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/admin_header.css')}}">


    <!-- google tajawal font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal&display=swap" rel="stylesheet">

    <!-- page icon -->
    <link rel="icon" href="{{asset('CSS&JS/pics/page icon.png')}}">

    <!-- search in select option -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"
        integrity="sha256-+C0A5Ilqmu4QcSPxrlGpaZxJ04VjsRjKu+G82kl5UJk=" crossorigin="anonymous"></script>
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css"
        integrity="sha2\56-ze/OEYGcFbPRmvCnrSeKbRTtjG4vGLHXgOqsyLFTRjg=" crossorigin="anonymous" />


</head>

<body>



    <!-- start of header -->
    <div class="intro">
        <a href="adminstyle"><img src="{{asset('CSS&JS/logo/makkalogo2.png')}}" target="_blank" alt="logo"
                title="Makka Stones" class="logo"></a>
        <h1 class="name"> Hallo, <p id="admin_name"></p>
        </h1>
        <a href="{{ route('auth.logout') }}" class="logout">Logout</a>
        <a href="adminstyle" class="homebtn">Home</a>
    </div>
    <style>
    .homebtn {
        background-color: whitesmoke;
        padding: 9px;
        margin: 10px;
        color: #000;
        text-decoration: none;
        font-size: 18px;
        font-weight: bold;
    }

    .homebtn:hover {
        text-decoration: none;
        color: #000;

    }
    </style>
    <!-- end of header -->
    <br>

    <!-- strart of body -->
    <div class="body">
        <form onsubmit="return checkBeforeSubmit()" id="form" action="{{ route('admin.addEmailPhotoLogic') }}" class="form"
            name="form1" onsubmit="return !!(ValidateEmail(document.form1.productCode));" method="POST"
            enctype="multipart/form-data">
            @csrf
            @if(Session::get('success'))
            <div
                style=" text-align: center; color: #F59393; background-color: #F2F2F2; border: 2px solid #F59393; border-radius: 25px; padding: 10px; margin:10px; font-weight: bold; color: #58B846; border: 1px solid #58B846; ">
                {{Session::get('success')}}
            </div>
            @endif

            @if(Session::get('fail'))
            <div
                style=" color: #F59393; background-color: #F2F2F2; border: 2px solid #F59393; border-radius: 25px; padding: 2%; margin:2%; font-weight: bold; text-align: center; ">
                {{Session::get('fail')}}
            </div>
            @endif

            <h1>Add Email Image</h1>
            <hr />
            <br>

            <label for="image">  إضافة صورة </label>
            <input required name="image" id="image" type="file" accept="image/*"> <br>

            <label for="descr"> اسم الصورة </label>
            <input required name="descr" id="descr" type="text"> <br>

            <input type="hidden" value='{{$AdminLoggedUserInfo->name}}' id="entered_by" name="entered_by" 
                readonly>

            <input type="submit" value="Add Image" id="button1" class="button" />
           
            <script>
                var data = <?= json_encode($AdminLoggedUserInfo) ?>;
                if (data == null) {
                    document.getElementById('html').remove();
                    window.location.replace("notauth");
                }
                var name = <?=json_encode($AdminLoggedUserInfo['name'])?>;
                document.getElementById("admin_name").innerHTML += ` ` + name + ` `;
                document.getElementById("entered_by").value = ` ` + name + ` `;
            </script>
        </form>

    </div>
    <!-- end of body -->
    <br>
    <!-- start of footer -->
    <script>
    var wasSubmitted = false;

    function checkBeforeSubmit() {
        if (!wasSubmitted) {
            wasSubmitted = true;
            return wasSubmitted;
        }
        return false;
    }


    var loadFile = function(event) {
        var output = document.getElementById('output');
        output.src = URL.createObjectURL(event.target.files[0]);
        document.getElementById("output2").src = URL.createObjectURL(event.target.files[0]);
        output.onload = function() {
            URL.revokeObjectURL(output.src) // free memory
        }
    };
    </script>
    <div class="copyright">
        &copy; Copyright 2022 - All rights reserved |
        <a href="https://makkastones.com/" target="_self">makkastones.com</a>
    </div>

    <!-- end of footer -->

    <script src="{{asset('CSS&JS/originaljavascript/add_product.js')}}"></script>

    <noscript class="noscript">
        <div id="div100">
            Please enable javascript in your browser
        </div>
    </noscript>
    <style>
    body {
        position: relative;
    }
    input {
        width: 500px;
    }
    .noscript {
        width: 100%;
        height: 100%;
        /* will cover the text displayed when javascript is enabled*/
        z-index: 100000;
        /* higher than other z-index */
        position: absolute;
    }

    .noscript #div100 {
        display: block;
        height: 100%;
        background-color: white;
    }
    </style>
    <noscript>
        <META HTTP-EQUIV="Refresh" CONTENT="0;URL=jserror">
    </noscript>


</body>

</html>