<!DOCTYPE html>
<html id="html" lang="en">

<head>

    <meta charset="UTF-8">
    <title>Delete Email Photo</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"></script>
    <!-- cities select box -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"></script>

    <!-- search in select option -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"
        integrity="sha256-+C0A5Ilqmu4QcSPxrlGpaZxJ04VjsRjKu+G82kl5UJk=" crossorigin="anonymous"></script>
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css"
        integrity="sha2\56-ze/OEYGcFbPRmvCnrSeKbRTtjG4vGLHXgOqsyLFTRjg=" crossorigin="anonymous" />


    <!-- local css -->
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/normalize.css')}}">
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/preloader.css')}}">
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/remove_product_style.css')}}">
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/copyright.css')}}">
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/admin_header.css')}}">


    <!-- google tajawal font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal&display=swap" rel="stylesheet">


    <!-- page icon -->
    <link rel="icon" href="{{asset('CSS&JS/pics/page icon.png')}}">

</head>

<body>



    <!-- start of header -->
    <div class="intro">
        <a href="adminstyle"><img src="{{asset('CSS&JS/logo/makkalogo2.png')}}" target="_blank" alt="logo"
                title="Makka Stones" class="logo"></a>
        <h1 class="name"> Hallo, <p id="name"></p>
        </h1>
        <a href="{{ route('auth.logout') }}" class="logout">Logout</a>
        <a href="adminstyle" class="homebtn">Home</a>

    </div>
    <!-- end of header -->
    <style>
    .homebtn {
        background-color: whitesmoke;
        padding: 9px;
        margin: 10px;
        color: #000;
        text-decoration: none;
        font-size: 18px;
        font-weight: bold;
    }

    .homebtn:hover {
        text-decoration: none;
        color: #000;

    }
    </style>
    <!-- start of body -->
    <div class="body">
        <form id="form" action="{{ route('admin.DeleteEmailPhotoLogic') }}" class="form" name="form1"
            onsubmit="return checkBeforeSubmit()" method="post">
            @if (Session::has('fail'))
            <span class="error2">

                <h2 style="color: #F59393;
    background-color: #F2F2F2;
    border: 2px solid #F59393;
    border-radius: 25px;
    padding: 15px;
    margin: 0 auto;
    margin-bottom: 0px;
    font-size:20px;
    width: 30%;
    font-weight: bold;
"> {{ Session::get('fail') }} </h2>

            </span>
            @endif

            @if (Session::has('success'))
            <div class="succ">

                {{ Session::get('success') }}

            </div>

            @endif

            @csrf

            <h1>Delete Email Images</h1>
            <hr />

            @foreach ($images as $image)
            <label>
                <input type="checkbox" name="checkbox_name[]" value="{{$image->id}}">
                <img src="{{ asset('emailPics/' . $image->image) }}" alt="Image">
                <figcaption> {{$image->desc}} </figcaption>
            </label>
            @endforeach




            <input type="submit" class="button" id="remove" value="Delete Selected Images" />

        </form>
    </div>
    <!-- end of body -->



    <!-- start of footer -->

    <div class="copyright">
        &copy; Copyright 2022 - All rights reserved |
        <a href="https://makkastones.com/" target="_self">makkastones.com</a>
    </div>

    <!-- end of footer -->

    <script>
    const form = document.querySelector('form');
    const checkboxes = form.querySelectorAll('input[type="checkbox"]');
    const submitButton = form.querySelector('#remove');

    // Disable submit button by default
    submitButton.disabled = true;

    // Add event listener to each checkbox
    checkboxes.forEach((checkbox) => {
        checkbox.addEventListener('change', () => {
            // Check if at least one checkbox is checked
            const isChecked = Array.from(checkboxes).some((checkbox) => checkbox.checked);
            // Enable or disable submit button based on checked status
            submitButton.disabled = !isChecked;
        });
    });



    var data = <?= json_encode($AdminLoggedUserInfo) ?>;
    var images = <?= json_encode($images) ?>;
    if (data == null) {
        document.getElementById('html').remove();
        window.location.replace("notauth");
    }
    document.getElementById("name").innerHTML += ` ` + data.name + ` `;



    var wasSubmitted = false;

    function checkBeforeSubmit() {
        if (!wasSubmitted) {
            wasSubmitted = true;
            return wasSubmitted;
        }
        return false;
    }
    </script>
    <noscript class="noscript">
        <div id="div100">
            Please enable javascript in your browser
        </div>
    </noscript>
    <style>
    body {
        position: relative;
    }

    .noscript {
        width: 100%;
        height: 100%;
        /* will cover the text displayed when javascript is enabled*/
        z-index: 100000;
        /* higher than other z-index */
        position: absolute;
    }

    .noscript #div100 {
        display: block;
        height: 100%;
        background-color: white;
    }

    label {
        display: inline-block;
        position: relative;
        margin: 10px;
        cursor: pointer;
    }

    input[type="checkbox"] {
        position: absolute;
        left: -9999px;
    }

    form img {
        width: 100px;
        height: 100px;
        border: 2px solid #ccc;
        border-radius: 5px;
    }

    input[type="checkbox"]:checked+img {
        border: 7px solid #4CAF50;
    }

    figcaption {
        display: block;
        margin-top: 5px;
    }

    input[type="submit"]:disabled {
        background-color: #ccc;
        color: #999;
        cursor: not-allowed;
    }
    </style>
    <noscript>
        <META HTTP-EQUIV="Refresh" CONTENT="0;URL=jserror">
    </noscript>
    <script src="{{asset('CSS&JS/originaljavascript/remove_product.js')}}"></script>

    <script>
    console.log(images);
    </script>
</body>

</html>