<!DOCTYPE html>
<html id="html" lang="ar">

<head>

    <meta charset="UTF-8">
    <title>Admin Control</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- local css -->
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/normalize.css')}}">
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/preloader.css')}}">
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/admin-control_style.css')}}">
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/copyright.css')}}">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.0/css/all.min.css"
        integrity="sha512-10/jx2EXwxxWqCLX/hHth/vu2KY3jCF70dCQB8TSgNjbCVAC/8vai53GfMDrO2Emgwccf2pJqxct9ehpzG+MTw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.12.0-2/css/all.min.css" rel="stylesheet">

    <!-- google tajawal font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal&display=swap" rel="stylesheet">

    <!-- page icon -->
    <link rel="icon" href="{{asset('CSS&JS/pics/page icon.png')}}">

</head>

<body>




    <!-- start of header -->
    <div class="intro">
        <a href="#"><img src="{{asset('CSS&JS/logo/makkalogo2.png')}}" target="_blank" alt="logo" title="Makka Stones"
                class="logo"></a>
        <h1 class="name"> Welcome Back, <span id="name"></span> </h1>
        <a href="{{ route('auth.logout') }}" class="button">تسجيل الخروج</a>

    </div>
    <!-- end of header -->


    @csrf
    @if(Session::get('success'))
    <div style="
                    text-align: center;
  color: #F59393;
  background-color: #F2F2F2;
  border: 2px solid #F59393;
  border-radius: 25px;
  padding: 2%;
    margin:2%;
  font-weight: bold;
  color: #58B846;
  border: 2px solid #58B846;
                    ">
        {{Session::get('success')}}
    </div>
    @endif

    @if(Session::get('fail'))
    <div style="
                      color: #F59393;
  background-color: #F2F2F2;
  border: 2px solid #F59393;
  border-radius: 25px;
  padding: 2%;
    margin:2%;
  font-weight: bold;
  text-align: center;
                    ">
        {{Session::get('fail')}}
    </div>
    @endif


    @php
    $role = $LoggedUserInfo['role'] ;
    @endphp
    <!-- strart of body -->
    <div class="body">
        <div id="data-container"> </div>
        <div class="grid-container">
            <p id="controllerType">لوحة التحكم</p>
            <p id="controllerType" style="margin:0; direction:rtl;">
                عدد ساعات العمل المقدرة:
                <!-- <input type="text" id="sec" class="sec" readonly>
                <input type="text" id="min" class="min" readonly>
                <input type="text" id="hour" class="hour" readonly> -->
                <span style="margin:0; direction:قفم;">
                    <span id="hours">00</span>:
                    <span id="minutes">00</span>:
                    <span id="seconds">00</span>
                </span>
            </p>
            <div id="products">

                @if ($role == '0')
                <a href="{{ route('admin.addCompanies') }}" class="item">اضافة شركات </a>
                <a href="{{ route('admin.ChangePassword') }}" class="item">تغيير كلمة المرور </a>
                <a href="{{ route('admin.companies') }}" class="item">شركاتي </a>
                <a href="{{ route('admin.workers-report') }}" class="item">تقاريري </a>

                @endif

                @if ($role == '1')
                <a href="{{ route('admin.addProduct') }}" class="item">إضافة صور </a>
                <a href="{{ route('admin.delete') }}" class="item">مسح صور </a>
                <a href="{{ route('admin.addCompanies') }}" class="item">اضافة شركات </a>
                <a href="{{ route('admin.ChangePassword') }}" class="item">تغيير كلمة المرور </a>
                <a href="{{ route('admin.companies') }}" class="item">شركاتي </a>
                <a href="{{ route('admin.workers-report') }}" class="item">تقاريري </a>

                @endif

                @if ($role == '2')
                <a href="{{ route('admin.companies') }}" class="item">الشركات </a>
                <a href="{{ route('admin.companystats') }}" class="item">تقارير الموظفين في ادخال الشركات </a>
                <a href="{{ route('admin.workers') }}" class="item"> الموظفين واحصاءات</a>
                <a href="{{ route('admin.workers-report') }}" class="item">تقارير الموظفين (البصمة)</a>
                <a href="{{ route('admin.addProduct') }}" class="item">إضافة صور </a>
                <a href="{{ route('admin.delete') }}" class="item">مسح صور </a>
                <a href="{{ route('admin.addCompanies') }}" class="item">اضافة شركات </a>
                <a href="{{ route('admin.ChangePassword') }}" class="item">تغيير كلمة المرور </a>
                @endif




            </div>

            <div id="products">

            
                <a href="{{ route('admin.AddEmailPhoto') }}" class="item">إضافة صور للميل </a>
                <a href="{{ route('admin.DeleteEmailPhoto') }}" class="item">حذف صور للميل </a>
                <a href="{{ route('admin.sendEmails') }}" class="item"> إرسال ايميلات </a>





            </div>


        </div>
        <!-- <input type="button" class="button" value="تسجيل الخروج"> -->

    </div>

    <br>

    <!-- end of body -->

    <!-- start of footer -->

    <div id="copyright" class="copyright">
        &copy; Copyright 2022 - All rights reserved |
        <a href="https://makkastones.com/" target="_self">makkastones.com</a>
    </div>

    <!-- end of footer -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.3/jquery.min.js"
        integrity="sha512-STof4xm1wgkfm7heWqFJVn58Hm3EtS31XFaagaa8VMReCXAkQnJZ+jEy8PCC/iT18dFy95WcExNHFTqLyp72eQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
    var name = <?=json_encode($LoggedUserInfo['name'])?>;
    document.getElementById("name").innerHTML += ` ` + name + ` `;

    var dataa = <?=json_encode($LoggedUserInfo)?>;


    new Date().toLocaleString("en-US", {
        timeZone: 'Africa/Cairo'
    })
    var start_time = <?=json_encode($LoggedUserInfo['start'])?>;

    // setInterval(function() {
    //     document.getElementById("sec").value = ` ` + Math.ceil(Date.now() / 1000 - start_time) + ` ثانية `;
    //     document.getElementById("min").value = ` ` + Math.ceil((Date.now() / 1000 - start_time) / 60) +
    //         ` دقيقة `;
    //     document.getElementById("hour").value = ` ` + Math.round(((Date.now() / 1000 - start_time) / 60) / 60) +
    //         ` ساعة `;
    // }, 1000);




    // Default start time in seconds
    let startTime = Math.ceil(Date.now() / 1000 - start_time);

    // Timer interval, set to 1000 milliseconds (1 second)
    let interval = 1000;

    // Timer ID for clearing the interval later
    let timerId;

    // Get the display elements
    let hoursDisplay = document.querySelector("#hours");
    let minutesDisplay = document.querySelector("#minutes");
    let secondsDisplay = document.querySelector("#seconds");

    // Function to update the display
    function updateTime() {
        // Calculate the number of hours, minutes, and seconds
        let totalSeconds = startTime;
        let hours = Math.floor(totalSeconds / 3600);
        totalSeconds %= 3600;
        let minutes = Math.floor(totalSeconds / 60);
        let seconds = totalSeconds % 60;

        // Update the display
        hoursDisplay.textContent = `${hours} ساعة`;
        minutesDisplay.textContent = `${minutes} دقيقة`;
        secondsDisplay.textContent = `${seconds} ثانية`;


        // Increment the start time by 1 second
        startTime += 1;
    }
    // Start the timer
    timerId = setInterval(updateTime, interval);
    </script>
    <script src="{{asset('CSS&JS/originaljavascript/admin-control.js')}}"></script>
    <noscript class="noscript">
        <div id="div100">
            Please enable javascript in your browser
        </div>
    </noscript>
    <style>
    body {
        position: relative;
    }

    .noscript {
        width: 100%;
        height: 100%;
        /* will cover the text displayed when javascript is enabled*/
        z-index: 100000;
        /* higher than other z-index */
        position: absolute;
    }

    .noscript #div100 {
        display: block;
        height: 100%;
        background-color: white;
    }
    </style>
    <noscript>
        <META HTTP-EQUIV="Refresh" CONTENT="0;URL=jserror">
    </noscript>

</body>

</html>