<!DOCTYPE html>
<html id="html" lang="ar">

<head>

    <meta charset="UTF-8">
    <title>Companies </title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- bootstrap for nav bar -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.0/css/all.min.css"
        integrity="sha512-10/jx2EXwxxWqCLX/hHth/vu2KY3jCF70dCQB8TSgNjbCVAC/8vai53GfMDrO2Emgwccf2pJqxct9ehpzG+MTw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.12.0-2/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"
        integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <!-- needed nootstrap libraries to Coordinate divs -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <script src="https://code.jquery.com/jquery-2.2.4.js" charset="utf-8"></script>

    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/workers_reports.css')}}">

    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/copyright.css')}}">

    <!-- local css -->



    <!-- sweet alert -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css"
        integrity="sha2\56-ze/OEYGcFbPRmvCnrSeKbRTtjG4vGLHXgOqsyLFTRjg=" crossorigin="anonymous" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>


    <!-- google tajawal font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal&display=swap" rel="stylesheet">

    <!-- page icon -->
    <link rel="icon" href="{{asset('CSS&JS/pics/page icon.png')}}">


    <!-- search in select options -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />


</head>

<body>



    <!-- back to top button -->
    <button onclick="topFunction()" id="myBtn" title="Go to top"> <i class="las la-angle-double-up"></i> </button>



    <!-- start of header -->
    <div class="intro">
        <a href="adminstyle"><img src="{{asset('CSS&JS/logo/makkalogo2.png')}}" target="_blank" alt="logo"
                title="makkaStones" class="logo"></a>
        <h1 class="name"> مرحبًا بك يا <p id="name"></p>
        </h1>
        <a href="{{ route('auth.logout') }}" class="button">تسجيل الخروج</a>
        <a href="adminstyle" class="button">الرئيسية </a>
    </div>
    <!-- end of header -->



    <!-- strart of body -->

    <body><br>
        <div id="total_num" style=" text-decoration: none; margin:5px;" ></div>
            
        <button class="download" onclick="ExportToExcel('xlsx')">تحميل ملف ال Excel</button>


        <label for="nameFilter">فلتر بناءا علي الدولة</label>
        <select class="js-example-basic-single" name="nameFilter" id="nameFilter" onchange="getFilterValue()">
            <option selected disabled value=''>-- اختر دولة من الدول المتاحة --</option>
        </select> <br>


        @if($AdminLoggedUserInfo['role'] == 2)
        <label for="nameFilter2">فلتره بناءا علي الاسم</label>
        <select name="nameFilter2" id="nameFilter2" onchange="getFilterValue()">
            <option selected disabled value=''>-- اختر اسم --</option>
        </select> <br>

        <script>
        var admins = <?= json_encode($admins) ?>;



        // console.log(admins)
        for (let i = 0; i < admins.length; i++) {
            document.getElementById("nameFilter2").innerHTML += "<option value='" + admins[i]['name'] + "'>" + admins[i][
                'name'
            ] + "</option>"
        }
        </script>
        

        @endif


        <h2 id="sort_ins">(اضغط علي رأس الجدول لترتيبه حسب أي عنصر من عناصره)</h2>
        <div class="table">
            <table class="sortable" id="finished_table">

                <tr class="table_header">
                    <th>#</th>
                    <th> الهاتف/الواتس</th>
                    <th>الإيميل</th>
                    <th> ملاحظات</th>
                    <th> الدولة</th>
                    <th>ادخال</th>
                    <th>تاريخ الادخال</th>
                </tr>


            </table>

        </div>



        <!-- end of body -->
        <br>


        <!-- start of footer -->
        <div id="copyright" class="copyright">
            &copy; Copyright 2022 - All rights reserved |
            <a href="https://makkastones.com/" target="_self">makkastones.com</a>
        </div>

        <script type="text/javascript" src="https://unpkg.com/xlsx@0.15.1/dist/xlsx.full.min.js"></script>

        <!-- <script src="{{asset('CSS&JS/originaljavascript/orders.js')}}"></script> -->
        <script>
        // BACK TO TOP 
        //Get the button
        var x = 0;
        var mybutton = document.getElementById("myBtn");
        // When the user scrolls down 20px from the top of the document, show the button
        window.onscroll = function() {
            scrollFunction();

        };

        function topFunction() {
            document.body.scrollTop = 0;
            document.documentElement.scrollTop = 0;
        }

        // hide by default
        $("#myBtn").hide();

        function scrollFunction() {
            if (document.body.scrollTop > 1200 || document.documentElement.scrollTop > 1200) {
                // mybutton.style.display = "block";
                $("#myBtn").show(500);
            } else {
                // mybutton.style.display = "none";
                $("#myBtn").hide(500);
            }
        }


function getFilterValue() {
    if (document.getElementById("nameFilter2")) {
        var data = [ document.getElementById("nameFilter2").value , document.getElementById("nameFilter").value];
    }
    else {
        var data = ['' , document.getElementById("nameFilter").value];

    }
    // Get the table rows
    var rows = $("#finished_table").find("tr");
    if (this.value == "") {
        rows.show();
        return;
    }
    
    // Hide all the rows initially
    rows.hide();

    // Filter the rows; check each term in data
    rows.filter(function (i, v) {
        if (i == 0) {
            // Always show the first row
            return true;
        }
        else if ($(this).is(":contains('" + data[0] + "')") && $(this).is(":contains('" + data[1] + "')")) {
            return true;
        }
        return false;
    })
    // Show the rows that match.
    .show();
}







        var finished = <?=json_encode($data)?>;
        var data = <?= json_encode($AdminLoggedUserInfo) ?>;

        var country = <?= json_encode($country) ?>;

        // console.log(country)
        for (let i = 0; i < country.length; i++) {
            document.getElementById("nameFilter").innerHTML += "<option value='" + country[i]['country'] + "'>" +
                country[i]['country'] + "</option>"
        }

        var usedNames = {};
        $("select > option").each(function() {
            if (usedNames[this.text]) {
                $(this).remove();
            } else {
                usedNames[this.text] = this.value;
            }
        });

        // console.log(data)


        finished_size = Object.keys(finished).length;
        if (finished_size == 0) {
            document.getElementById("sort_ins").style.display = "none";
            document.getElementById("finished_table").innerHTML = '<h1>لا يوجد شركات لعضرها</h1> ';
        }
        document.getElementById("total_num").innerHTML = "عدد الشركات الكلية هو: " + finished_size + " ";
        var country_arr = [];
        var finished_table = document.getElementById("finished_table");
        for (let i = 0; i < finished_size; i++) {

            var row = finished_table.insertRow(1);
            var cell1 = row.insertCell(0);
            var cell2 = row.insertCell(1);
            var cell3 = row.insertCell(2);
            var cell4 = row.insertCell(3);
            var cell5 = row.insertCell(4);
            var cell6 = row.insertCell(5);
            var cell7 = row.insertCell(6);

            cell1.innerHTML = " " + (i + 1) + " ";
            cell2.innerHTML = "" + finished[i]['phone'] + "";
            cell3.innerHTML = "" + finished[i]['email'] + "";
            cell4.innerHTML = "" + finished[i]['notes'] + "";
            cell5.innerHTML = "" + finished[i]['country'] + "";
            country_arr.push(finished[i]['country']);
            cell6.innerHTML = "" + finished[i]['entered_by'] + "";
            cell7.innerHTML = "" + finished[i]['created_at'] + "";

        }
        // console.log(finished)

        function countElements(arr) {
            let count = {};
            for (let i = 0; i < arr.length; i++) {
                let element = arr[i];
                count[element] = (count[element] || 0) + 1;
            }
            return count;
        }

        function addCountToPage(count) {
        let container = document.getElementById("total_num");
        let sortedCount = Object.entries(count).sort(([a], [b]) => a.localeCompare(b));
        for (let [key, value] of sortedCount) {
            let item = document.createElement("div");
            item.innerHTML = key + ": " + value;
            container.appendChild(item);
        }
        }

        let count = countElements(country_arr);
        addCountToPage(count);


        // console.log(count);

        $(document).ready(function() {
            $(".js-example-basic-single").select2();
        });

        function ExportToExcel(type, fn, dl) {
            var elt = document.getElementById('finished_table');

            var hiddenElems = [];
                var elems = elt.querySelectorAll('*');
                for (var i = 0; i < elems.length; i++) {
                    var elem = elems[i];
                    var style = window.getComputedStyle(elem);
                    if (style.display === 'none' || style.visibility === 'hidden') {
                        hiddenElems.push(elem);
                    }
                }

                hiddenElems.forEach(function(elem) {
                    elem.parentNode.removeChild(elem);
                });

            var wb = XLSX.utils.table_to_book(elt, {
                sheet: "sheet1"
            });

            return dl ?
                XLSX.write(wb, {
                    bookType: type,
                    bookSST: true,
                    type: 'base64'
                }) :
                XLSX.writeFile(wb, fn || ('Makka Stones All Companies.' + (type || 'xlsx')));
        }






        document.getElementById("name").innerHTML += ` ` + data.name + ` `;

        var wasSubmitted = false;

        function checkBeforeSubmit() {
            if (!wasSubmitted) {
                wasSubmitted = true;
                return wasSubmitted;
            }
            return false;
        }
        </script>
        <script src="https://www.kryogenix.org/code/browser/sorttable/sorttable.js"></script>

        <noscript class="noscript">
            <div id="div100">
                Please enable javascript in your browser
            </div>
        </noscript>
        <style>
        body {
            position: relative;
        }

        .noscript {
            width: 100%;
            height: 100%;
            /* will cover the text displayed when javascript is enabled*/
            z-index: 100000;
            /* higher than other z-index */
            position: absolute;
        }

        .noscript #div100 {
            display: block;
            height: 100%;
            background-color: white;
        }
        #total_num div {
            margin:3px auto;
            text-align:left;
            width: 300px;
        }
        #total_num  {
            text-align: center;
            margin: 0;
            margin-top: 20px;
            color: white;
            font-size: 17px;
            font-weight: bold;
            text-decoration: underline;
        }
        table {
          border-collapse: collapse;
          width: 100%;
          margin: 2% 0%;
          margin-top: 8px;
          /* display: none; */
          box-shadow: rgba(0, 0, 0, 0.35) 0px 5px 15px;
  
          justify-content: space-evenly;
          overflow: auto;
          align-content: center;
      }
        </style>
        <noscript>
            <META HTTP-EQUIV="Refresh" CONTENT="0;URL=jserror">
        </noscript>



    </body>

</html>