<!DOCTYPE html>
<html id="html" lang="en">

<head>

    <meta charset="UTF-8">
    <title>Send 30 Email </title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"></script>
    <!-- cities select box -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.4/jquery.min.js"
        integrity="sha512-pumBsjNRGGqkPzKHndZMaAG+bir374sORyzM3uulLV14lN5LyykqNk8eEeUlUkB3U0M4FApyaHraT65ihJhDpQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>


    <!-- local css -->
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/normalize.css')}}">
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/preloader.css')}}">
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/send_emails.css')}}">
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/copyright.css')}}">
    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/admin_header.css')}}">


    <!-- google tajawal font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal&display=swap" rel="stylesheet">



    <!-- sweet alert -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css"
        integrity="sha2\56-ze/OEYGcFbPRmvCnrSeKbRTtjG4vGLHXgOqsyLFTRjg=" crossorigin="anonymous" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>


    <!-- page icon -->
    <link rel="icon" href="{{asset('CSS&JS/pics/page icon.png')}}">

</head>
<div id="loader2" class="full-image">
    <h1>جار ارسال الإيميلات برجاء لا تغلق الصفحة ... عادة مايستغرق ارسال 30 ايميل من 3 إلي 4 دقائق </h1>
    <div class="lds-ellipsis">
        <div></div>
        <div></div>
        <div></div>
        <div></div>
    </div>
</div>

<body>



    <!-- start of header -->
    <div class="intro">
        <a href="adminstyle"><img src="{{asset('CSS&JS/logo/makkalogo2.png')}}" target="_blank" alt="logo"
                title="Makka Stones" class="logo"></a>
        <h1 class="name"> Hallo, <p id="name"></p>
        </h1>
        <a href="{{ route('auth.logout') }}" class="logout">Logout</a>
        <a href="adminstyle" class="homebtn">Home</a>

    </div>
    <!-- end of header -->
    <style>
    .homebtn {
        background-color: whitesmoke;
        padding: 9px;
        margin: 10px;
        color: #000;
        text-decoration: none;
        font-size: 18px;
        font-weight: bold;
    }

    .homebtn:hover {
        text-decoration: none;
        color: #000;

    }
    </style>
    <!-- start of body -->
    <div class="body">

        <br>
        <br>

        <div class="f_container" style="background-color:white;">
            <h2> الايميل المستخدم: {{$AdminLoggedUserInfo['email']}}</h2>
            <hr style="margin: 1px;">
            <h2> الهاتف المستخدم: {{$AdminLoggedUserInfo['phone']}}</h2>
        </div>
        <form onsubmit="return checkBeforeSubmit()" id="form" action="{{ route('admin.sendEmailsCheck') }}"
            class="form" name="form1" method="POST" enctype="multipart/form-data">
            @csrf
            @if(Session::get('success'))

            <div
                style=" text-align: center; font-size:18px; color: #F59393; background-color: #F2F2F2; border: 2px solid #F59393; border-radius: 25px; padding: 10px; margin:10px; font-weight: bold; color: #58B846; border: 1px solid #58B846; ">
                {{Session::get('success')}}
                <script type="text/javascript">
                    const audio = new Audio("https://msqan.com/CSS&JS/audios/sucess.mp3");
                    audio.play();
                swal("تم بنجاح!", "{{Session::get('success')}}", "success");
                </script>

            </div>
            @endif

            @if(Session::get('fail'))
            <div
                style=" color: #F59393; background-color: #F2F2F2; border: 2px solid #F59393; border-radius: 25px; font-size:18px; padding: 2%; margin:2%; font-weight: bold; text-align: center; ">
                {{Session::get('fail')}}
                <script type="text/javascript">
                swal("فشل!", "{{Session::get('fail')}}", "error");
                </script>

            </div>
            @endif

            <h1> إرسال 30 إيميل بحد أقصي</h1>


            <div class="ch_container">
                <p> اختر الصور والعنوان الذين تريدهم في الإيميل</p>

                @foreach ($images as $image)
                <label class="ch_label">
                    <input type="checkbox" name="checkbox_name[]" value="{{$image->id}}">
                    <img src="{{ asset('emailPics/' . $image->image) }}" alt="Image">
                    <figcaption> {{$image->desc}} </figcaption>
                </label>
                @endforeach
            </div>




            <div class="block">
                <label for="subject"> عنوان الإيميل (Subject)</label>
                <input type="text" placeholder="Enter Subject of Email" id="subject" name="subject" required />
            </div>

            <div class="block">
                <label for="body"> محتوي الإيميل
                    <br>
                    افصل بين الجمل بسطر واحد فقط
                </label>
                <textarea id="Email_body" name="body" required> </textarea>
            </div>

            <div class="block">
                <label for="emails">
                    الإيميلات ( ضع كل إيميل في سطر منفصل)
                    <br>
                    السطور الفارغة لا تحتسب
                </label>
                <textarea id="emails" name="emails" required> </textarea>
            </div>



            <input type="submit" value="إرسال الايميلات" id="remove" class="button" />
            <input type="hidden" id="entered_by" name="entered_by" readonly required>

        </form>
    </div>
    <!-- end of body -->



    <!-- start of footer -->

    <div class="copyright">
        &copy; Copyright 2022 - All rights reserved |
        <a href="https://makkastones.com/" target="_self">makkastones.com</a>
    </div>

    <!-- end of footer -->

    <script>
    $('#loader2').hide();

    if (localStorage.getItem("Email_body")) {
        document.getElementById("Email_body").value = localStorage.getItem("Email_body");
    }
    if (localStorage.getItem("subject")) {
        document.getElementById("subject").value = localStorage.getItem("subject");
    }



    const form = document.querySelector('form');
    const checkboxes = form.querySelectorAll('input[type="checkbox"]');
    const submitButton = form.querySelector('#remove');

    // Disable submit button by default
    submitButton.disabled = true;

    // Add event listener to each checkbox
    checkboxes.forEach((checkbox) => {
        checkbox.addEventListener('change', () => {
            // Check if at least one checkbox is checked
            const isChecked = Array.from(checkboxes).some((checkbox) => checkbox.checked);
            // Enable or disable submit button based on checked status
            submitButton.disabled = !isChecked;
        });
    });



    var data = <?= json_encode($AdminLoggedUserInfo) ?>;
    var images = <?= json_encode($images) ?>;

    document.getElementById("name").innerHTML += ` ` + data.name + ` `;



    var wasSubmitted = false;

    function checkBeforeSubmit() {

        let emailBody = document.getElementById("Email_body").value.trim();
        let recipientEmails = document.getElementById("emails").value.trim();

        if (emailBody === "") {
            swal("فشل!", "يجب أن لا يكون محتوى الإيميل فارغا", "error");
            return false;
        }

        if (recipientEmails === "") {
            swal("فشل!", "يجب أن لا يكون الإيميلات المرسلة إليها فارغة", "error");
            return false;
        }

        if (document.getElementById("subject").value.length <= 10) {
            swal("فشل!", "أقل عدد حروف لعنوان الايميل يجب ان يكون اكثر من 10 حروف", "error");
            return false;
        }

        if (document.getElementById("Email_body").value.length <= 20) {
            swal("فشل!", "أقل عدد حروف لمحتوي الايميل يجب ان يكون اكثر من 20 حرف", "error");
            return false;
        }

        let lines = recipientEmails.split("\n").filter(line => line.trim() !== "");

        if (lines.length > 30) {
            swal("فشل!", "اكبر عدد سطور بها ايميل هو  30 سطر يوجد " + lines.length + " ", "error");
            return false;
        }

        let regex =
            /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;

        for (let i = 0; i < lines.length; i++) {
            lines[i] = lines[i].trim();
            if (!regex.test(lines[i])) {
                swal("فشل!", "عنوان البريد الإلكتروني غير صالح: " + lines[i], "error");
                return false;
            }
        }

        // Check for duplicate emails
        let uniqueEmails = new Set(lines);
        console.log(uniqueEmails)
        console.log(lines)

        if (uniqueEmails.size !== lines.length) {
            swal("فشل!", " يوجد بريد إلكتروني مكرر اكثر من مرة"  , "error");
            return false;
        }
        
        // return false;

        localStorage.setItem("Email_body", document.getElementById("Email_body").value);
        localStorage.setItem("subject", document.getElementById("subject").value);

        // return false;
        if (!wasSubmitted) {
            wasSubmitted = true;
            $("#loader2").show(300);
            return wasSubmitted;
        }
        return false;
    }
    </script>
    <noscript class="noscript">
        <div id="div100">
            Please enable javascript in your browser
        </div>
    </noscript>

    <noscript>
        <META HTTP-EQUIV="Refresh" CONTENT="0;URL=jserror">
    </noscript>

    <script>
    console.log(images);
    </script>
</body>

</html>