<!DOCTYPE html>
<html id="html" lang="ar">

<head>

    <meta charset="UTF-8">
    <title>Reports </title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- bootstrap for nav bar -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.0/css/all.min.css"
        integrity="sha512-10/jx2EXwxxWqCLX/hHth/vu2KY3jCF70dCQB8TSgNjbCVAC/8vai53GfMDrO2Emgwccf2pJqxct9ehpzG+MTw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.12.0-2/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"
        integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <!-- needed nootstrap libraries to Coordinate divs -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <script src="https://code.jquery.com/jquery-2.2.4.js" charset="utf-8"></script>

    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/workers_reports.css')}}">

    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/copyright.css')}}">

    <!-- local css -->



    <!-- sweet alert -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css"
        integrity="sha2\56-ze/OEYGcFbPRmvCnrSeKbRTtjG4vGLHXgOqsyLFTRjg=" crossorigin="anonymous" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>


    <!-- google tajawal font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal&display=swap" rel="stylesheet">

    <!-- page icon -->
    <link rel="icon" href="{{asset('CSS&JS/pics/page icon.png')}}">





</head>

<body>



    <!-- back to top button -->
    <button onclick="topFunction()" id="myBtn" title="Go to top"> <i class="las la-angle-double-up"></i> </button>



    <!-- start of header -->
    <div class="intro">
        <a href="adminstyle"><img src="{{asset('CSS&JS/logo/makkalogo2.png')}}" target="_blank" alt="logo"
                title="makkaStones" class="logo"></a>
        <h1 class="name"> مرحبًا بك يا <p id="name"></p>
        </h1>
        <a href="{{ route('auth.logout') }}" class="button">تسجيل الخروج</a>
        <a href="adminstyle" class="button">الرئيسية </a>
    </div>
    <!-- end of header -->



    <!-- strart of body -->

    <body><br>

        <button class="download" onclick="ExportToExcel('xlsx')">تحميل ملف ال Excel</button>

        <label for="dateFilter">فلتره بناءا علي التاريخ</label>
        <input type="date" id="dateFilter" name="dateFilter" value="" onchange="getFilterValue(this.value)">
        <br>
        <script>
        var curr_dadte = new Date().toISOString().split("T")[0];
        dateFilter.max = curr_dadte;
        var mybutton = document.getElementById("dateFilter").value = curr_dadte;
        </script>
        @if($AdminLoggedUserInfo['role'] == 2)
        <label for="nameFilter">فلتره بناءا علي الاسم</label>
        <select name="nameFilter" id="nameFilter" onchange="getFilterValue(this.value)">
            <option selected disabled value=''>-- اختر اسم --</option>
        </select> <br>

        <script>
        var admins = <?= json_encode($admins) ?>;



        console.log(admins)
        for (let i = 0; i < admins.length; i++) {
            document.getElementById("nameFilter").innerHTML += "<option value='" + admins[i]['name'] + "'>" + admins[i][
                'name'
            ] + "</option>"
        }
        </script>
        }

        @endif


        <h2 id="sort_ins">(اضغط علي رأس الجدول لترتيبه حسب أي عنصر من عناصره)</h2>
        <div class="table">
            <table class="sortable" id="finished_table">

                <tr class="table_header">
                    <th>#</th>
                    <th> الاسم</th>
                    <th>تاريخ تسجيل الدخول</th>
                    <th>وقت تسجيل الدخول</th>
                    <th>وقت تسجيل الخروج</th>
                    <th>المدة</th>
                    <!-- <th></th> -->
                    <!-- <th>المحافظة</th> -->


                </tr>


            </table>

        </div>



        <!-- end of body -->
        <br>


        <!-- start of footer -->
        <div id="copyright" class="copyright">
            &copy; Copyright 2022 - All rights reserved |
            <a href="https://makkastones.com/" target="_self">makkastones.com</a>
        </div>

        <script type="text/javascript" src="https://unpkg.com/xlsx@0.15.1/dist/xlsx.full.min.js"></script>

        <!-- <script src="{{asset('CSS&JS/originaljavascript/orders.js')}}"></script> -->
        <script>
        // BACK TO TOP 
        //Get the button
        var x = 0;
        var mybutton = document.getElementById("myBtn");
        // When the user scrolls down 20px from the top of the document, show the button
        window.onscroll = function() {
            scrollFunction();

        };

        function topFunction() {
            document.body.scrollTop = 0;
            document.documentElement.scrollTop = 0;
        }

        // hide by default
        $("#myBtn").hide();

        function scrollFunction() {
            if (document.body.scrollTop > 1200 || document.documentElement.scrollTop > 1200) {
                // mybutton.style.display = "block";
                $("#myBtn").show(500);
            } else {
                // mybutton.style.display = "none";
                $("#myBtn").hide(500);
            }
        }

        const getFilterValue = (value) => {
            console.log(value);

            const trs = document.querySelectorAll('#finished_table tr:not(.table_header)')
            const filter = value
            const regex = new RegExp(filter, 'i')
            const isFoundInTds = td => regex.test(td.innerHTML)
            const isFound = childrenArr => childrenArr.some(isFoundInTds)
            const setTrStyleDisplay = ({
                style,
                children
            }) => {
                style.display = isFound([
                    ...children // <-- All columns
                ]) ? '' : 'none'
            }

            trs.forEach(setTrStyleDisplay)
        }
        console.log(curr_dadte)

        var finished = <?=json_encode($data)?>;
        var data = <?= json_encode($AdminLoggedUserInfo) ?>;



        finished_size = Object.keys(finished).length;
        if (finished_size == 0) {
            document.getElementById("sort_ins").style.display = "none";
            document.getElementById("finished_table").innerHTML = '<h1>لا يوجد متحكمين لعرضهم</h1> '
        }
        var finished_table = document.getElementById("finished_table");
        var all_dates = [];
        for (let i = 0; i < finished_size; i++) {


            var row = finished_table.insertRow(1);
            var cell1 = row.insertCell(0);
            var cell2 = row.insertCell(1);
            var cell3 = row.insertCell(2);
            var cell4 = row.insertCell(3);
            var cell5 = row.insertCell(4);
            var cell6 = row.insertCell(5);

            if (finished[i]['status'] == "0") {
                var status = "<div id=" + finished[i]['id'] + "> <p class='offline'>Offline</p> </div>"
            } else if (finished[i]['status'] == "1") {
                var status = "<div id=" + finished[i]['id'] + "> <p class='online'>Online</p> </div>"
            } else {
                var status = "<div id=" + finished[i]['id'] + "> not defined </div>"

            }


            if (finished[i]['role'] == "0") {
                var role = "<p class='role'>إدخال شركات فقط</p>"
            } else if (finished[i]['role'] == "1") {
                var role = "<p class='role'>إدخال شركات والتحكم في صور الموقع</p>"
            } else if (finished[i]['role'] == "2") {
                var role = "<p class='role'>الكل</p>"
            } else {
                var role = "not defined"

            }
            if (finished[i]['logged_in'] != null) {
                var date = finished[i]['logged_in'].split(' ');
            } else {
                var date = ['', ''];
            }


            var strNum = finished[i]['duration'].split('-')[0];
            var tamyeez = finished[i]['duration'].split('-')[1];
            var floatNum = parseFloat(strNum);
            // var Fraction = Math.ceil((decimal / 100) * 60);
            if (tamyeez == ' minute' || tamyeez == ' seconds') {
                var finalDuration = "" + Math.ceil(floatNum) + " - " + tamyeez + " "
            } else if (tamyeez == ' hour') {
                var finalDuration = " " + floatNum.toString().split('.')[0] + ":" + Math.ceil((getDecimalPart(
                    floatNum) / 100) * 60) + " - " + tamyeez + "  "
            } else if (tamyeez == ' day') {
                var finalDuration = " " + floatNum.toString().split('.')[0] + ":" + Math.ceil((getDecimalPart(
                    floatNum) / 100) * 24) + " - " + tamyeez + "  "
            }
            cell1.innerHTML = " " + (i + 1) + " ";
            cell2.innerHTML = "" + finished[i]['acc_name'] + "";
            cell3.innerHTML = "" + date[0] + "";
            cell4.innerHTML = "" + date[1] + "";
            cell5.innerHTML = "" + finished[i]['logged_out'] + "";
            cell6.innerHTML = "" + finalDuration + "";

            // cell6.innerHTML = " " + floatNum.split('.')[0] + " : " + Fraction + " - " + finished[i]['duration'].split(
            //     '-')[1] + "";


            all_dates.push("" + date[0] + "");


        }

        console.log(all_dates)

        function getDecimalPart(num) {
            if (Number.isInteger(num)) {
                return 0;
            }
            const decimalStr = num.toString().split('.')[1];
            return Number(decimalStr);
        }

        let minDate = new Date(all_dates[0]);
        for (let i = 1; i < all_dates.length; i++) {
            const date = new Date(all_dates[i]);
            if (date < minDate) {
                minDate = date;
            }
        }


        dateFilter.min = minDate.toISOString().slice(0, 10);

        function ExportToExcel(type, fn, dl) {
            var elt = document.getElementById('finished_table');
            var wb = XLSX.utils.table_to_book(elt, {
                sheet: "sheet1"
            });
            return dl ?
                XLSX.write(wb, {
                    bookType: type,
                    bookSST: true,
                    type: 'base64'
                }) :
                XLSX.writeFile(wb, fn || ('Makka Stones workers daily login Report.' + (type || 'xlsx')));
        }


        console.log(data);
        // if (data == null) {
        //     document.getElementById('html').remove();
        //     window.location.replace("notauth");
        // }
        // if (data.type != 0 && data.type != 3) {
        //     document.getElementById('html').remove();
        //     window.location.replace("notauth");
        // }
        document.getElementById("name").innerHTML += ` ` + data.name + ` `;
        // document.getElementById("entered_by").value = ``+data.name +``;




        var wasSubmitted = false;

        function checkBeforeSubmit() {
            if (!wasSubmitted) {
                wasSubmitted = true;
                return wasSubmitted;
            }
            return false;
        }


        getFilterValue(curr_dadte);
        </script>
        <script src="https://www.kryogenix.org/code/browser/sorttable/sorttable.js"></script>

        <noscript class="noscript">
            <div id="div100">
                Please enable javascript in your browser
            </div>
        </noscript>
        <style>
        body {
            position: relative;
        }

        .noscript {
            width: 100%;
            height: 100%;
            /* will cover the text displayed when javascript is enabled*/
            z-index: 100000;
            /* higher than other z-index */
            position: absolute;
        }

        .noscript #div100 {
            display: block;
            height: 100%;
            background-color: white;
        }

        #finished_table td,
        #finished_table th {

            direction: ltr !important;
        }
        </style>
        <noscript>
            <META HTTP-EQUIV="Refresh" CONTENT="0;URL=jserror">
        </noscript>



    </body>

</html>