<!DOCTYPE html>
<html id="html" lang="ar">

<head>

    <meta charset="UTF-8">
    <title>Workers</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- bootstrap for nav bar -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.0/css/all.min.css"
        integrity="sha512-10/jx2EXwxxWqCLX/hHth/vu2KY3jCF70dCQB8TSgNjbCVAC/8vai53GfMDrO2Emgwccf2pJqxct9ehpzG+MTw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.12.0-2/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"
        integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <!-- needed nootstrap libraries to Coordinate divs -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <script src="https://code.jquery.com/jquery-2.2.4.js" charset="utf-8"></script>

    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/workers.css')}}">

    <link rel="stylesheet" href="{{asset('CSS&JS/originalcss/copyright.css')}}">

    <!-- local css -->



    <!-- sweet alert -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css"
        integrity="sha2\56-ze/OEYGcFbPRmvCnrSeKbRTtjG4vGLHXgOqsyLFTRjg=" crossorigin="anonymous" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>


    <!-- google tajawal font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal&display=swap" rel="stylesheet">

    <!-- page icon -->
    <link rel="icon" href="{{asset('CSS&JS/pics/page icon.png')}}">





</head>

<body>



    <!-- back to top button -->
    <button onclick="topFunction()" id="myBtn" title="Go to top"> <i class="las la-angle-double-up"></i> </button>



    <!-- start of header -->
    <div class="intro">
        <a href="adminstyle"><img src="{{asset('CSS&JS/logo/makkalogo2.png')}}" target="_blank" alt="logo"
                title="makkaStones" class="logo"></a>
        <h1 class="name"> مرحبًا بك يا <p id="name"></p>
        </h1>
        <a href="{{ route('auth.logout') }}" class="button">تسجيل الخروج</a>
        <a href="adminstyle" class="button">الرئيسية </a>
    </div>
    <!-- end of header -->



    <!-- strart of body -->

    <body><br>
        <button class="download" onclick="ExportToExcel('xlsx')">تحميل ملف ال Excel</button>

        <h2 id="sort_ins">(اضغط علي رأس الجدول لترتيبه حسب أي عنصر من عناصره)</h2>
        <div class="table">
            <table class="sortable" id="finished_table">

                <tr class="table_header">
                    <th>#</th>
                    <th> الاسم</th>
                    <th>الإيميل</th>
                    <th>الهاتف</th>
                    <th>الحالة</th>
                    <th>اخر ظهور</th>
                    <th> نوع التحكم</th>
                    <!-- <th>المحافظة</th> -->


                </tr>


            </table>

        </div>



        <!-- end of body -->
        <br>

        <div id="stats_container" class="stats_container">
        <label for="nameFilter2" style="color:white;">فلتره بناءا علي الاسم</label>
        <select name="nameFilter2" id="nameFilter2" onchange="getFilterValue()">
            <option selected disabled value=''>-- اختر اسم --</option>
        </select> 

        <script>
        var admins = <?= json_encode($data) ?>;
        // console.log(admins)
        for (let i = 0; i < admins.length; i++) {
            document.getElementById("nameFilter2").innerHTML += "<option value='" + admins[i]['name'] + "'>" + admins[i][
                'name'
            ] + "</option>"
        }
        </script>


        </div>
        <!-- start of footer -->
        <div id="copyright" class="copyright">
            &copy; Copyright 2022 - All rights reserved |
            <a href="https://makkastones.com/" target="_self">makkastones.com</a>
        </div>

        <script type="text/javascript" src="https://unpkg.com/xlsx@0.15.1/dist/xlsx.full.min.js"></script>

        <!-- <script src="{{asset('CSS&JS/originaljavascript/orders.js')}}"></script> -->
        <script>
        // BACK TO TOP 
        //Get the button
        var x = 0;
        var mybutton = document.getElementById("myBtn");
        // When the user scrolls down 20px from the top of the document, show the button
        window.onscroll = function() {
            scrollFunction();

        };

        function topFunction() {
            document.body.scrollTop = 0;
            document.documentElement.scrollTop = 0;
        }

        // hide by default
        $("#myBtn").hide();

        function scrollFunction() {
            if (document.body.scrollTop > 1200 || document.documentElement.scrollTop > 1200) {
                // mybutton.style.display = "block";
                $("#myBtn").show(500);
            } else {
                // mybutton.style.display = "none";
                $("#myBtn").hide(500);
            }
        }



        var finished = <?=json_encode($data)?>;
        var data = <?= json_encode($AdminLoggedUserInfo) ?>;

        var companies = <?= json_encode($companies) ?>;
        console.log(companies);

        console.log(finished)
        finished_size = Object.keys(finished).length;
        if (finished_size == 0) {
            document.getElementById("sort_ins").style.display = "none";
            document.getElementById("finished_table").innerHTML = '<h1>لا يوجد متحكمين لعرضهم</h1> '
        }
        var finished_table = document.getElementById("finished_table");
        for (let i = 0; i < finished_size; i++) {


            var row = finished_table.insertRow(1);
            var cell1 = row.insertCell(0);
            var cell2 = row.insertCell(1);
            var cell3 = row.insertCell(2);
            var cell4 = row.insertCell(3);
            var cell5 = row.insertCell(4);
            var cell6 = row.insertCell(5);
            var cell7 = row.insertCell(6);


            if (finished[i]['status'] == "0") {
                var status = "<div id=" + finished[i]['id'] + "> <p class='offline'>Offline</p> </div>"
            } else if (finished[i]['status'] == "1") {
                var status = "<div id=" + finished[i]['id'] + "> <p class='online'>Online</p> </div>"
            } else {
                var status = "<div id=" + finished[i]['id'] + "> not defined </div>"

            }


            if (finished[i]['role'] == "0") {
                var role = "<p class='role'>إدخال شركات فقط</p>"
            } else if (finished[i]['role'] == "1") {
                var role = "<p class='role'>إدخال شركات والتحكم في صور الموقع</p>"
            } else if (finished[i]['role'] == "2") {
                var role = "<p class='role'>الكل</p>"
            } else {
                var role = "not defined"

            }


            cell1.innerHTML = " " + (i + 1) + " ";
            cell2.innerHTML = "" + finished[i]['name'] + "";
            cell3.innerHTML = "" + finished[i]['email'] + "";
            cell4.innerHTML = "" + finished[i]['phone'] + "";
            cell5.innerHTML = "" + status + "";
            cell6.innerHTML = "<div id='last_seen" + finished[i]['id'] + "' >" + finished[i]['last_seen'] + "</div>";
            cell7.innerHTML = "" + role + "";





        }


        let start = Date.now();

        // setInterval(() => {
        //     $.ajax({
        //         type: "GET",
        //         url: "{{ route('status_check') }}",
        //         success: function(data) {
        //             for (let i = 0; i < data.length; i++) {
        //                 if (data[i]['status'] == '0') {
        //                     document.getElementById("" + data[i]['id'] + "").innerHTML =
        //                         "<div id=" + data[i]['id'] +
        //                         "> <p class='offline'>Offline</p> </div>"
        //                 } else if (data[i]['status'] == '1') {
        //                     document.getElementById("" + data[i]['id'] + "").innerHTML =
        //                         "<div id=" + data[i]['id'] + "> <p class='online'>Online</p> </div>"
        //                 } else {
        //                     document.getElementById("" + data[i]['id'] + "").innerHTML =
        //                         "<div id=" + data[i]['id'] + "> not defined </div>"
        //                 }

        //                 document.getElementById("last_seen" + data[i]['id'] + "").innerHTML =
        //                     "<div id=" + data[i]['id'] + "> <p>" + data[i]['last_seen'] +
        //                     "</p> </div>"
        //             }
        //             // console.log( Date.now() - start);

        //         }
        //     });
        // }, 5000);

        function ExportToExcel(type, fn, dl) {
            var elt = document.getElementById('finished_table');
            var wb = XLSX.utils.table_to_book(elt, {
                sheet: "sheet1"
            });
            return dl ?
                XLSX.write(wb, {
                    bookType: type,
                    bookSST: true,
                    type: 'base64'
                }) :
                XLSX.writeFile(wb, fn || ('Makka Stones Workers Status.' + (type || 'xlsx')));
        }


        console.log(data);
        // if (data == null) {
        //     document.getElementById('html').remove();
        //     window.location.replace("notauth");
        // }
        // if (data.type != 0 && data.type != 3) {
        //     document.getElementById('html').remove();
        //     window.location.replace("notauth");
        // }
        document.getElementById("name").innerHTML += ` ` + data.name + ` `;
        // document.getElementById("entered_by").value = ``+data.name +``;




        var wasSubmitted = false;

        function checkBeforeSubmit() {
            if (!wasSubmitted) {
                wasSubmitted = true;
                return wasSubmitted;
            }
            return false;
        }




function getFilterValue() {
    if (document.getElementById("nameFilter2")) {
        var data = [ document.getElementById("nameFilter2").value];
    }

    // Get the table rows
    var rows = $("#stats_table_det").find("tr");
    if (this.value == "") {
        rows.show();
        return;
    }
    
    // Hide all the rows initially
    rows.hide();

    // Filter the rows; check each term in data
    rows.filter(function (i, v) {
        if (i == 0) {
            // Always show the first row
            return true;
        }
        else if ($(this).is(":contains('" + data[0] + "')") ) {
            return true;
        }
        return false;
    })
    // Show the rows that match.
    .show();
}





        function countCountriesByEnteredBy(companies) {
  return companies.reduce((stats, company) => {
    const { entered_by, country, email, phone, notes } = company;
    if (!stats[entered_by]) {
      stats[entered_by] = {};
    }
    if (!stats[entered_by][country]) {
      stats[entered_by][country] = {
        count: 0,
        emailCount: 0,
        phoneCount: 0,
        notesCount: 0,
      };
    }
    stats[entered_by][country].count++;
    if (email !== "") {
      stats[entered_by][country].emailCount++;
    }
    if (phone !== "") {
      stats[entered_by][country].phoneCount++;
    }
    if (notes !== "") {
      stats[entered_by][country].notesCount++;
    }
    return stats;
  }, {});
}

const stats = countCountriesByEnteredBy(companies);

const table = document.createElement("table");
table.setAttribute("id", "stats_table_det");
table.innerHTML = `
  <thead>
    <tr>
      <th>الموظف </th>
      <th>الدولة</th>
      <th>عدد الشركات</th>
      <th> عدد اليميلات</th>
      <th> عدد ارقام الهاتف</th>
      <th> عدد الملاحظات</th>
    </tr>
  </thead>
  <tbody>
    ${Object.entries(stats)
      .map(([enteredBy, countries]) => {
        return Object.entries(countries)
          .map(([country, { count, emailCount, phoneCount, notesCount }]) => {
            return `
              <tr>
                <td>${enteredBy}</td>
                <td>${country}</td>
                <td>${count}</td>
                <td>${emailCount}</td>
                <td>${phoneCount}</td>
                <td>${notesCount}</td>
              </tr>
            `;
          })
          .join("");
      })
      .join("")}
  </tbody>
`;

document.getElementById('stats_container').innerHTML += '<br><h1> جدول يوضح احصائيات كل موظف في كل دولة </h1>';
document.getElementById('stats_container').appendChild(table);
console.log(stats)





const totalsTable = document.createElement("table");
totalsTable.id = "totals_table";
totalsTable.innerHTML = `
  <thead>
    <tr>
      <th> الموظف</th>
      <th>العدد الكلي للشركات</th>
      <th> عدد الايميلات</th>
      <th>عدد ارقام الهاتف </th>
      <th> عدد الملاحظات</th>
    </tr>
  </thead>
  <tbody>
    ${Object.entries(stats)
      .map(([enteredBy, countries]) => {
        const { count: totalCount, emailCount: totalEmailCount, phoneCount: totalPhoneCount, notesCount: totalNotesCount } = Object.values(countries).reduce((totals, { count, emailCount, phoneCount, notesCount }) => {
          return {
            count: totals.count + count,
            emailCount: totals.emailCount + emailCount,
            phoneCount: totals.phoneCount + phoneCount,
            notesCount: totals.notesCount + notesCount,
          };
        }, { count: 0, emailCount: 0, phoneCount: 0, notesCount: 0 });
        return `
          <tr>
            <td>${enteredBy}</td>
            <td>${totalCount}</td>
            <td>${totalEmailCount}</td>
            <td>${totalPhoneCount}</td>
            <td>${totalNotesCount}</td>
          </tr>
        `;
      })
      .join("")}
  </tbody>
`;

const totalsRow = document.createElement("tr");
totalsRow.innerHTML = `
  <td>Total:</td>
  <td>${Object.values(stats).reduce((sum, countries) => sum + Object.values(countries).reduce((subsum, { count }) => subsum + count, 0), 0)}</td>
  <td>${Object.values(stats).reduce((sum, countries) => sum + Object.values(countries).reduce((subsum, { emailCount }) => subsum + emailCount, 0), 0)}</td>
  <td>${Object.values(stats).reduce((sum, countries) => sum + Object.values(countries).reduce((subsum, { phoneCount }) => subsum + phoneCount, 0), 0)}</td>
  <td>${Object.values(stats).reduce((sum, countries) => sum + Object.values(countries).reduce((subsum, { notesCount }) => subsum + notesCount, 0), 0)}</td>
`;
totalsTable.querySelector("tbody").appendChild(totalsRow);
document.getElementById('stats_container').innerHTML += '<br><h1> جدول يوضح احصائيات كل موظف في كل الدول </h1>';
document.getElementById('stats_container').appendChild(totalsTable);








        </script>
        <script src="https://www.kryogenix.org/code/browser/sorttable/sorttable.js"></script>

        <noscript class="noscript">
            <div id="div100">
                Please enable javascript in your browser
            </div>
        </noscript>
        <style>
        body {
            position: relative;
        }

        .noscript {
            width: 100%;
            height: 100%;
            /* will cover the text displayed when javascript is enabled*/
            z-index: 100000;
            /* higher than other z-index */
            position: absolute;
        }

        .noscript #div100 {
            display: block;
            height: 100%;
            background-color: white;
        }
        .stats_container table {
            border-collapse: collapse;
          width: 100%;
          margin: 2% 0%;
          margin-top: 8px;
          /* display: none; */
          box-shadow: rgba(0, 0, 0, 0.35) 0px 5px 15px;
  
          justify-content: space-evenly;
          overflow: auto;
          align-content: center;
        }
        .stats_container th {
          background: white;
          position: sticky;
          top: 0;
        }
      table td ,table th {
          border: 1px solid #555252;
          padding: 4px;
          transition: 0.5s;
          font-weight: bolder;
      }
      table tr:nth-child(even) {
    background-color: #f2f2f2;
}
table tr:nth-child(odd) {
    background-color: #d8d8d8;
}
table th {
    padding-top: 5px;
    padding-bottom: 5px;
    text-align: center;
    font-size: 11px;
    background-color: #1e1e1e !important;
    cursor: pointer;
    color: whitesmoke;
}
h1 {
    margin-bottom:5px !important;
}
label {
    padding:5px;
}
        </style>
        <noscript>
            <META HTTP-EQUIV="Refresh" CONTENT="0;URL=jserror">
        </noscript>



    </body>

</html>